/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class OSCJavaToByteArrayConverter {
    protected ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private byte[] intBytes = new byte[4];
    private byte[] longintBytes = new byte[8];
    private char[] stringChars = new char[2048];
    private byte[] stringBytes = new byte[2048];
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;

    private byte[] alignBigEndToFourByteBoundry(byte[] byArray) {
        int n;
        int n2 = byArray.length % 4;
        if (n2 == 0) {
            return byArray;
        }
        int n3 = 4 - n2;
        byte[] byArray2 = new byte[n3 + byArray.length];
        for (n = 0; n < n3; ++n) {
            byArray2[n] = 0;
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray2[n3 + n] = byArray[n];
        }
        return byArray2;
    }

    public void appendNullCharToAlignStream() {
        int n = this.stream.size() % 4;
        int n2 = 4 - n;
        for (int i = 0; i < n2; ++i) {
            this.stream.write(0);
        }
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public void write(byte[] byArray) {
        this.writeUnderHandler(byArray);
    }

    public void write(int n) {
        this.writeInteger32ToByteArray(n);
    }

    public void write(Float f) {
        this.writeInteger32ToByteArray(Float.floatToIntBits(f.floatValue()));
    }

    public void write(Integer n) {
        this.writeInteger32ToByteArray(n);
    }

    public void write(BigInteger bigInteger) {
        this.writeInteger64ToByteArray(bigInteger.longValue());
    }

    public void write(String string) {
        int n;
        int n2 = string.length();
        string.getChars(0, n2, this.stringChars, 0);
        int n3 = n2 % 4;
        int n4 = 4 - n3;
        for (n = 0; n < n4; ++n) {
            this.stringChars[n2++] = '\u0000';
        }
        for (n = 0; n < n2; ++n) {
            this.stringBytes[n] = (byte)(this.stringChars[n] & 0xFF);
        }
        this.stream.write(this.stringBytes, 0, n2);
    }

    public void write(char c) {
        this.stream.write(c);
    }

    public void write(Object object) {
        if (null == object) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.write(objectArray[i]);
            }
            return;
        }
        if (object instanceof Float) {
            this.write((Float)object);
            return;
        }
        if (object instanceof String) {
            this.write((String)object);
            return;
        }
        if (object instanceof Integer) {
            this.write((Integer)object);
            return;
        }
        if (object instanceof BigInteger) {
            this.write((BigInteger)object);
            return;
        }
    }

    public void writeType(Class clazz) {
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = OSCJavaToByteArrayConverter.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz)) {
            this.stream.write(105);
            return;
        }
        if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = OSCJavaToByteArrayConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(clazz)) {
            this.stream.write(104);
            return;
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = OSCJavaToByteArrayConverter.class$("java.lang.Float")) : class$java$lang$Float).equals(clazz)) {
            this.stream.write(102);
            return;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = OSCJavaToByteArrayConverter.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz)) {
            this.stream.write(100);
            return;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = OSCJavaToByteArrayConverter.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
            this.stream.write(115);
            return;
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = OSCJavaToByteArrayConverter.class$("java.lang.Character")) : class$java$lang$Character).equals(clazz)) {
            this.stream.write(99);
            return;
        }
    }

    public void writeTypesArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (null == objectArray[i]) continue;
            if (Boolean.TRUE.equals(objectArray[i])) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(objectArray[i])) {
                this.stream.write(70);
                continue;
            }
            this.writeType(objectArray[i].getClass());
        }
    }

    public void writeTypes(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (null == e) continue;
            if (e.getClass().isArray()) {
                this.stream.write(91);
                this.writeTypesArray((Object[])e);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(e)) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(e)) {
                this.stream.write(70);
                continue;
            }
            this.writeType(e.getClass());
        }
        this.appendNullCharToAlignStream();
    }

    private void writeUnderHandler(byte[] byArray) {
        try {
            this.stream.write(this.alignBigEndToFourByteBoundry(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeInteger32ToByteArray(int n) {
        this.intBytes[3] = (byte)n;
        this.intBytes[2] = (byte)(n >>>= 8);
        this.intBytes[1] = (byte)(n >>>= 8);
        this.intBytes[0] = (byte)(n >>>= 8);
        try {
            this.stream.write(this.intBytes);
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeInteger64ToByteArray(long l) {
        this.longintBytes[7] = (byte)l;
        this.longintBytes[6] = (byte)(l >>>= 8);
        this.longintBytes[5] = (byte)(l >>>= 8);
        this.longintBytes[4] = (byte)(l >>>= 8);
        this.longintBytes[3] = (byte)(l >>>= 8);
        this.longintBytes[2] = (byte)(l >>>= 8);
        this.longintBytes[1] = (byte)(l >>>= 8);
        this.longintBytes[0] = (byte)(l >>>= 8);
        try {
            this.stream.write(this.longintBytes);
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

